/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ChannelModel
implements IUnbakedGeometry<ChannelModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Map<ChannelModelPart, FluidCuboid> fluids;

    public ChannelModel(SimpleBlockModel model, Map<ChannelModelPart, FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 owner) {
        this.model.resolveParents(modelGetter, owner);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 location, boolean isGui3d) {
        class_1087 baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new Baked(baked, this.fluids);
    }

    public static class Baked
    extends ForwardingBakedModel {
        private final Map<ChannelModelPart, FluidCuboid> fluids;

        private Baked(class_1087 originalModel, Map<ChannelModelPart, FluidCuboid> fluids) {
            this.wrapped = originalModel;
            this.fluids = fluids;
        }

        public FluidCuboid getDownFluid() {
            return this.fluids.get((Object)ChannelModelPart.DOWN);
        }

        public FluidCuboid getCenterFluid(boolean flowing) {
            return this.fluids.get((Object)(flowing ? ChannelModelPart.CENTER_FLOWING : ChannelModelPart.CENTER_STILL));
        }

        public FluidCuboid getSideFlow(boolean out) {
            return this.fluids.get((Object)(out ? ChannelModelPart.SIDE_OUT : ChannelModelPart.SIDE_IN));
        }

        public FluidCuboid getSideStill() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_STILL);
        }

        public FluidCuboid getSideEdge() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_EDGE);
        }
    }

    private static class Loader
    implements IGeometryLoader<ChannelModel> {
        private Loader() {
        }

        public ChannelModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(deserializationContext, modelContents);
            JsonObject fluidJson = class_3518.method_15296((JsonObject)modelContents, (String)"fluids");
            EnumMap<ChannelModelPart, FluidCuboid> fluids = new EnumMap<ChannelModelPart, FluidCuboid>(ChannelModelPart.class);
            fluids.put(ChannelModelPart.DOWN, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)fluidJson, (String)"down")));
            JsonObject centerJson = class_3518.method_15296((JsonObject)fluidJson, (String)"center");
            fluids.put(ChannelModelPart.CENTER_STILL, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)centerJson, (String)"still")));
            fluids.put(ChannelModelPart.CENTER_FLOWING, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)centerJson, (String)"flowing")));
            JsonObject sideJson = class_3518.method_15296((JsonObject)fluidJson, (String)"side");
            fluids.put(ChannelModelPart.SIDE_STILL, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)sideJson, (String)"still")));
            fluids.put(ChannelModelPart.SIDE_IN, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)sideJson, (String)"in")));
            fluids.put(ChannelModelPart.SIDE_OUT, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)sideJson, (String)"out")));
            fluids.put(ChannelModelPart.SIDE_EDGE, FluidCuboid.fromJson(class_3518.method_15296((JsonObject)sideJson, (String)"edge")));
            return new ChannelModel(model, fluids);
        }
    }

    private static enum ChannelModelPart {
        CENTER_STILL,
        CENTER_FLOWING,
        SIDE_STILL,
        SIDE_IN,
        SIDE_OUT,
        SIDE_EDGE,
        DOWN;

    }
}

